---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-SQL Execution Detail（SQL実行詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` 行32-269
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` 行24-44
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.15
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.15
- E-05: `docs/code-to-docs/画面遷移図.md` SQLTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/SQL/execution/ | E-01 行32: WebUIPage("execution") | ○ |
| C-02 | idパラメータが必須 | E-01 行41-43: パラメータ取得とrequire | ○ |
| C-03 | sqlStore.execution()でデータ取得 | E-01 行46 | ○ |
| C-04 | sqlStore.executionMetrics()でメトリクス取得 | E-01 行126 | ○ |
| C-05 | sqlStore.planGraph()でグラフ取得 | E-01 行127 | ○ |
| C-06 | サマリーにSubmitted Time/Duration表示 | E-01 行72-76 | ○ |
| C-07 | Query ID表示（設定時のみ） | E-01 行78-83 | ○ |
| C-08 | Parent Execution表示（rootExecutionIdと異なる場合） | E-01 行85-93 | ○ |
| C-09 | Sub Executions表示（groupSubExecutionEnabled時） | E-01 行95-109 | ○ |
| C-10 | Running/Succeeded/Failed Jobs表示 | E-01 行110-112 | ○ |
| C-11 | DAGグラフダウンロード（SVG/DOT/TXT） | E-01 行114-123: select要素とdownloadリンク | ○ |
| C-12 | Plan Visualization表示（togglePlanViz） | E-01 行163: onclick="togglePlanViz()" | ○ |
| C-13 | Stage ID/Task IDチェックボックス | E-01 行173-174 | ○ |
| C-14 | DOTファイルをgraph.makeDotFile(metrics)で生成 | E-01 行179 | ○ |
| C-15 | Plan Details（デフォルト非表示） | E-01 行192-193: arrow-closed, display: none | ○ |
| C-16 | SQL / DataFrame Properties（デフォルト非表示） | E-01 行214-221: arrow-closed, collapsed | ○ |
| C-17 | Pandas API Properties（プレフィックス除去） | E-01 行231-233: pandasOnSparkConfPrefix除去 | ○ |
| C-18 | Python repr()風の値変換 | E-01 行237-241: JNull->None, JBool->capitalize, JString->'s' | ○ |
| C-19 | D3.js/dagre-d3/graphlib-dot/spark-sql-vizの4つのJSライブラリ | E-01 行148-153: 4つのscript/linkタグ | ○ |
| C-20 | データなし時のメッセージ | E-01 行138: "No information to display for query" | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面仕様がソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] DAGグラフの描画が正しくレンダリングされるか実機確認
- [ ] ダウンロード機能（SVG/DOT/TXT）が正常に動作するか確認
- [ ] Pandas API Properties変換が全データ型で正しいか確認
